/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.hls;

import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Objects;
import libsidutils.IOUtils;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.URLRequestPathServletParameters;
import ui.common.util.InternetUtil;

@WebServlet(name="ProxyServlet", displayName="ProxyServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/proxy/*"}, description="This serves as kind of a proxy to make internal HTTP requests of HLS protocol through HTTPS to avoid mixed content in the browser")
public class ProxyServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ProxyServletParameters servletParameters = new ProxyServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            URL url = servletParameters.getUrl();
            if (!url.toExternalForm().startsWith(IServletSystemProperties.ConvertServlet.HLS_DOWNLOAD_URL)) {
                throw new IOException();
            }
            URLConnection connection = InternetUtil.openConnection(url, this.configuration.getSidplay2Section());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy(connection.getInputStream(), bos);
            connection.getHeaderFields().entrySet().stream().filter(entry -> Objects.nonNull(entry.getKey())).forEach(entry -> ((List)entry.getValue()).forEach(value -> response.addHeader((String)entry.getKey(), value)));
            response.setContentLength(bos.size());
            response.getOutputStream().write(bos.toByteArray());
        }
        catch (IOException e) {
            response.setStatus(404);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.hls.ProxyServletParameters")
    public static class ProxyServletParameters
    extends URLRequestPathServletParameters {
    }
}

